<?php 
    // Including db_connect to prevent errors, but using static data below
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(102, 0, 0, 0.6), rgba(102, 0, 0, 0.6)), url('images/law-library-books.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Judgment Archive</h1>
        <p>Search Civil Appellate High Court judgments, decrees, and final orders.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #fff;">
    
    <div class="filter-container" style="background: #ffffff; border-top: 4px solid var(--primary-color); padding: 30px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); margin-bottom: 40px; border-radius: 5px;">
        <h3 style="color: var(--primary-color); margin-bottom: 20px;">Find a Judgment</h3>
        
        <form style="display: grid; grid-template-columns: repeat(auto-fit, minmax(220px, 1fr)); gap: 20px;">
            
            <div class="form-group">
                <label style="font-weight: 600; color: #555; display: block; margin-bottom: 5px;">Case Category</label>
                <select class="form-control" style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px;">
                    <option>All Categories</option>
                    <option>Land Acquisition</option>
                    <option>Partition Action</option>
                    <option>Money Recovery</option>
                    <option>Divorce / Custody</option>
                    <option>Testamentary</option>
                    <option>Writ Application</option>
                </select>
            </div>

            <div class="form-group">
                <label style="font-weight: 600; color: #555; display: block; margin-bottom: 5px;">Year</label>
                <select class="form-control" style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px;">
                    <option>2026</option>
                    <option>2025</option>
                    <option>2024</option>
                </select>
            </div>

            <div class="form-group">
                <label style="font-weight: 600; color: #555; display: block; margin-bottom: 5px;">Presiding Judge</label>
                <input type="text" placeholder="Justice Name..." class="form-control" style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px;">
            </div>

            <div class="form-group">
                <label style="font-weight: 600; color: #555; display: block; margin-bottom: 5px;">Keywords</label>
                <input type="text" placeholder="e.g. prescriptive title" class="form-control" style="width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px;">
            </div>

            <button class="btn-gold" style="grid-column: 1 / -1; justify-self: start; margin-top: 10px; border:none; cursor:pointer; padding: 12px 30px;">
                Search Archive
            </button>
        </form>
    </div>

    <div class="table-responsive" style="background: white; padding: 20px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color);">
        <table class="custom-table" style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr>
                    <th style="background: var(--primary-color); color: white; padding: 15px; text-align: left;">Date</th>
                    <th style="background: var(--primary-color); color: white; padding: 15px; text-align: left;">Case Number</th>
                    <th style="background: var(--primary-color); color: white; padding: 15px; text-align: left;">Parties</th>
                    <th style="background: var(--primary-color); color: white; padding: 15px; text-align: left;">Category</th>
                    <th style="background: var(--primary-color); color: white; padding: 15px; text-align: left;">Action</th>
                </tr>
            </thead>
            <tbody>
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px;">2026-01-15</td>
                    <td style="padding: 15px; font-weight: bold; color: var(--primary-color);">WP/HCCA/COL/45/2023</td>
                    <td style="padding: 15px;">Silva vs. Perera</td>
                    <td style="padding: 15px;"><span style="background: #e9ecef; padding: 4px 10px; border-radius: 12px; font-size: 0.8rem; font-weight: 600; color: #495057;">Partition</span></td>
                    <td style="padding: 15px;"><a href="#" style="color: var(--secondary-color); font-weight: bold;"><i class="fas fa-file-pdf"></i> View</a></td>
                </tr>
                
                <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px;">2026-01-12</td>
                    <td style="padding: 15px; font-weight: bold; color: var(--primary-color);">WP/HCCA/GPH/102/2024</td>
                    <td style="padding: 15px;">R.D.A vs. Gunasekara</td>
                    <td style="padding: 15px;"><span style="background: #e9ecef; padding: 4px 10px; border-radius: 12px; font-size: 0.8rem; font-weight: 600; color: #495057;">Land Acquisition</span></td>
                    <td style="padding: 15px;"><a href="#" style="color: var(--secondary-color); font-weight: bold;"><i class="fas fa-file-pdf"></i> View</a></td>
                </tr>
                
                <tr style="border-bottom: 1px solid #eee;">
                    <td style="padding: 15px;">2025-12-20</td>
                    <td style="padding: 15px; font-weight: bold; color: var(--primary-color);">WP/HCCA/KAL/88/2022</td>
                    <td style="padding: 15px;">Bank of Ceylon vs. Tradex Pvt Ltd</td>
                    <td style="padding: 15px;"><span style="background: #e9ecef; padding: 4px 10px; border-radius: 12px; font-size: 0.8rem; font-weight: 600; color: #495057;">Debt Recovery</span></td>
                    <td style="padding: 15px;"><a href="#" style="color: var(--secondary-color); font-weight: bold;"><i class="fas fa-file-pdf"></i> View</a></td>
                </tr>

                <tr style="border-bottom: 1px solid #eee; background-color: #fcfcfc;">
                    <td style="padding: 15px;">2025-11-05</td>
                    <td style="padding: 15px; font-weight: bold; color: var(--primary-color);">WP/HCCA/COL/11/2025</td>
                    <td style="padding: 15px;">Fernando vs. Fernando</td>
                    <td style="padding: 15px;"><span style="background: #e9ecef; padding: 4px 10px; border-radius: 12px; font-size: 0.8rem; font-weight: 600; color: #495057;">Divorce</span></td>
                    <td style="padding: 15px;"><a href="#" style="color: var(--secondary-color); font-weight: bold;"><i class="fas fa-file-pdf"></i> View</a></td>
                </tr>
            </tbody>
        </table>
        
        <div style="margin-top: 20px; text-align: right; font-size: 0.9rem; color: #666;">
            Showing 1 to 4 of 124 entries 
            <span style="margin-left: 10px;">
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">Previous</button>
                <button style="padding: 5px 10px; border: 1px solid var(--gold-accent); background: var(--gold-accent); color: white; cursor: pointer;">1</button>
                <button style="padding: 5px 10px; border: 1px solid #ddd; background: white; cursor: pointer;">Next</button>
            </span>
        </div>

    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>